USE [EleriumClean]
GO

/****** Object:  Table [dbo].[RewardTransaction]    Script Date: 10/3/2013 8:14:00 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[RewardTransaction](
	[ID] [int] IDENTITY(1657063,1) NOT NULL,
	[DailyBudgetID] [int] NULL,
	[OrderID] [int] NULL,
	[TransferUserID] [int] NULL,
	[UserID] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[PointChange] [money] NOT NULL,
	[SourceID] [int] NULL,
	[Type] [tinyint] NOT NULL,
 CONSTRAINT [PK_RewardTransaction] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

ALTER TABLE [dbo].[RewardTransaction]  WITH CHECK ADD  CONSTRAINT [FK_RewardTransaction_DailyBudget] FOREIGN KEY([DailyBudgetID])
REFERENCES [dbo].[RewardDailyBudget] ([ID])
GO

ALTER TABLE [dbo].[RewardTransaction] CHECK CONSTRAINT [FK_RewardTransaction_DailyBudget]
GO

ALTER TABLE [dbo].[RewardTransaction]  WITH CHECK ADD  CONSTRAINT [FK_RewardTransaction_StoreOrder] FOREIGN KEY([OrderID])
REFERENCES [dbo].[StoreOrder] ([ID])
GO

ALTER TABLE [dbo].[RewardTransaction] CHECK CONSTRAINT [FK_RewardTransaction_StoreOrder]
GO

ALTER TABLE [dbo].[RewardTransaction]  WITH CHECK ADD  CONSTRAINT [FK_RewardTransaction_User] FOREIGN KEY([UserID])
REFERENCES [dbo].[User] ([ID])
GO

ALTER TABLE [dbo].[RewardTransaction] CHECK CONSTRAINT [FK_RewardTransaction_User]
GO

ALTER TABLE [dbo].[RewardTransaction]  WITH CHECK ADD  CONSTRAINT [FK_RewardTransaction_UserByTransferUser] FOREIGN KEY([TransferUserID])
REFERENCES [dbo].[User] ([ID])
GO

ALTER TABLE [dbo].[RewardTransaction] CHECK CONSTRAINT [FK_RewardTransaction_UserByTransferUser]
GO

ALTER TABLE [dbo].[RewardTransaction]  WITH CHECK ADD  CONSTRAINT [CK_RewardTransaction_ID_FK_OnlyOneOrNone] CHECK  (([OrderID] IS NOT NULL AND [TransferUserID] IS NULL AND [DailyBudgetID] IS NULL OR [TransferUserID] IS NOT NULL AND [OrderID] IS NULL AND [DailyBudgetID] IS NULL OR [DailyBudgetID] IS NOT NULL AND [OrderID] IS NULL AND [TransferUserID] IS NULL OR [OrderID] IS NULL AND [TransferUserID] IS NULL AND [DailyBudgetID] IS NULL))
GO

ALTER TABLE [dbo].[RewardTransaction] CHECK CONSTRAINT [CK_RewardTransaction_ID_FK_OnlyOneOrNone]
GO

ALTER TABLE [dbo].[RewardTransaction]  WITH CHECK ADD  CONSTRAINT [CK_RewardTransaction_Type] CHECK  (([Type]=(9) OR [Type]=(8) OR [Type]=(7) OR [Type]=(6) OR [Type]=(5) OR [Type]=(4) OR [Type]=(3) OR [Type]=(2) OR [Type]=(1)))
GO

ALTER TABLE [dbo].[RewardTransaction] CHECK CONSTRAINT [CK_RewardTransaction_Type]
GO

EXEC sys.sp_addextendedproperty @name=N'EnumValues', @value=N'PointsGenerated=1;TransferredToUser=2;TransferredFromUser=3;BonusPointsAwarded=4;OrderPlaced=5;OrderCancelled=6;PointsExpired=7;OrderFulfilled=8;OrderRefunded=9;' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RewardTransaction', @level2type=N'COLUMN',@level2name=N'Type'
GO


